/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWValidationError;
import filenet.vw.toolkit.design.message.resources.VWResource;

public class VWValidationToolTip {
    private static final int MAX_TOOLTIP_WIDTH = 80;

    public static String createValidationToolTip(VWValidationError error) {
        String tooltip = null;
        int errorLevel = error.getLevel();
        int errorType = error.getErrorType();
        String name = error.getName();
        String message = error.getMessage();
        String info = error.getInfo();
        if (name != null || message != null || info != null) {
            String errorLevelString = VWValidationToolTip.getErrorLevelString(errorLevel);
            String errorTypeString = VWValidationToolTip.getErrorTypeString(errorType);
            String nameString = VWValidationToolTip.getNameString(name);
            String messageString = VWValidationToolTip.getMessageString(message);
            String infoString = VWValidationToolTip.getInfoString(info);
            tooltip = "<html>" + errorLevelString + errorTypeString + nameString + messageString + infoString + "</html>";
        }
        return tooltip;
    }

    private static String getErrorLevelString(int errorLevel) {
        String errorLevelString = null;
        switch (errorLevel) {
            case 1: {
                errorLevelString = VWResource.s_error;
                break;
            }
            case 2: {
                errorLevelString = VWResource.s_warning;
            }
        }
        errorLevelString = "<B>" + errorLevelString + "</B>";
        return errorLevelString;
    }

    private static String getErrorTypeString(int errorType) {
        String errorTypeString = null;
        switch (errorType) {
            case 4: {
                errorTypeString = VWResource.s_field;
                break;
            }
            case 7: {
                errorTypeString = VWResource.s_systemFunction;
                break;
            }
            case 8: {
                errorTypeString = VWResource.s_milestone;
                break;
            }
            case 3: {
                errorTypeString = VWResource.s_parameter;
                break;
            }
            case 10: {
                errorTypeString = VWResource.s_partnerLink;
                break;
            }
            case 2: {
                errorTypeString = VWResource.s_route;
                break;
            }
            case 9: {
                errorTypeString = VWResource.s_ruleSet;
                break;
            }
            case 11: {
                errorTypeString = VWResource.s_schema;
                break;
            }
            case 1: {
                errorTypeString = VWResource.s_step;
                break;
            }
            case 6: {
                errorTypeString = VWResource.s_workflow;
            }
        }
        errorTypeString = "<B>" + VWResource.s_errorType + "</B> " + errorTypeString + "<BR>";
        return errorTypeString;
    }

    private static String getNameString(String name) {
        String nameString = null;
        nameString = "<B>" + VWResource.s_nameColon + "</B> " + VWValidationToolTip.formatLongString(name) + "<BR>";
        return nameString;
    }

    private static String getMessageString(String message) {
        String messageString = null;
        messageString = "<B>" + VWResource.s_colon.toString(VWResource.s_message) + "</B> " + VWValidationToolTip.formatLongString(message) + "<BR>";
        return messageString;
    }

    private static String getInfoString(String info) {
        String infoString = null;
        infoString = "<B>" + VWResource.s_colon.toString(VWResource.s_information) + "</B> " + VWValidationToolTip.formatLongString(info);
        return infoString;
    }

    private static String formatLongString(String longStr) {
        String formatString = "";
        if (longStr != null) {
            if (longStr.length() <= 80) {
                formatString = longStr;
            } else {
                String tempString = longStr;
                while (tempString.length() > 80) {
                    formatString = formatString + tempString.substring(0, 79) + "<BR>";
                    tempString = tempString.substring(80, tempString.length());
                }
                formatString = formatString + tempString;
            }
        }
        return formatString;
    }
}

